---
name: automation-workflows
description: Design and implement automation workflows to save time and scale operations as a solopreneur. Use when identifying repetitive tasks to automate, building workflows across tools, setting up triggers and actions, or optimizing existing automations. Covers automation opportunity identification, workflow design, tool selection (Zapier, Make, n8n), testing, and maintenance. Trigger on "automate", "automation", "workflow automation", "save time", "reduce manual work", "automate my business", "no-code automation".
---

# Automation Workflows

## Overview
As a solopreneur, your time is your most valuable asset. Automation lets you scale without hiring. The goal is simple: automate anything you do more than twice a week that doesn't require creative thinking. This playbook shows you how to identify automation opportunities, design workflows, and implement them without writing code.

---

## Step 1: Identify What to Automate

Not every task should be automated. Start by finding the highest-value opportunities.

**Automation audit (spend 1 hour on this):**

1. Track every task you do for a week (use a notebook or simple spreadsheet)
2. For each task, note:
   - How long it takes
   - How often you do it (daily, weekly, monthly)
   - Whether it's repetitive or requires judgment

3. Calculate time cost per task:
   ```
   Time Cost = (Minutes per task × Frequency per month) / 60
   ```
   Example: 15 min task done 20x/month = 5 hours/month

4. Sort by time cost (highest to lowest)

**Good candidates for automation:**
- Repetitive (same steps every time)
- Rule-based (no complex judgment calls)
- High-frequency (daily or weekly)
- Time-consuming (takes 10+ minutes)

**Examples:**
- ✅ Sending weekly reports to clients (same format, same schedule)
- ✅ Creating invoices after payment
- ✅ Adding new leads to CRM from form submissions
- ✅ Posting social media content on a schedule
- ❌ Conducting customer discovery interviews (requires nuance)
- ❌ Writing custom proposals for clients (requires creativity)

**Low-hanging fruit checklist (start here):**
- [ ] Email notifications for form submissions
- [ ] Auto-save form responses to spreadsheet
- [ ] Schedule social posts in advance
- [ ] Auto-create invoices from payment confirmations
- [ ] Sync data between tools (CRM ↔ email tool ↔ spreadsheet)

---

## Step 2: Choose Your Automation Tool

Three main options for no-code automation. Pick based on complexity and budget.

**Tool comparison:**

| Tool | Best For | Pricing | Learning Curve | Power Level |
|---|---|---|---|---|
| **Zapier** | Simple, 2-3 step workflows | $20-50/month | Easy | Low-Medium |
| **Make (Integromat)** | Visual, multi-step workflows | $9-30/month | Medium | Medium-High |
| **n8n** | Complex, developer-friendly, self-hosted | Free (self-hosted) or $20/month | Medium-Hard | High |

**Selection guide:**
- Budget < $20/month → Try Zapier free tier or n8n self-hosted
- Need visual workflow builder → Make
- Simple 2-step workflows → Zapier
- Complex workflows with branching logic → Make or n8n
- Want full control and customization → n8n

**Recommendation for solopreneurs:** Start with Zapier (easiest to learn). Graduate to Make or n8n when you hit Zapier's limits.

---

## Step 3: Design Your Workflow

Before building, map out the workflow on paper or a whiteboard.

**Workflow design template:**

```
TRIGGER: What event starts the workflow?
  Example: "New row added to Google Sheet"

CONDITIONS (optional): Should this workflow run every time, or only when certain conditions are met?
  Example: "Only if Status column = 'Approved'"

ACTIONS: What should happen as a result?
  Step 1: [action]
  Step 2: [action]
  Step 3: [action]

ERROR HANDLING: What happens if something fails?
  Example: "Send me a Slack message if action fails"
```

**Example workflow (lead capture → CRM → email):**
```
TRIGGER: New form submission on website

CONDITIONS: Email field is not empty

ACTIONS:
  Step 1: Add lead to CRM (e.g., Airtable or HubSpot)
  Step 2: Send welcome email via email tool (e.g., ConvertKit)
  Step 3: Create task in project management tool (e.g., Notion) to follow up in 3 days
  Step 4: Send me a Slack notification: "New lead: [Name]"

ERROR HANDLING: If Step 1 fails, send email alert to me
```

**Design principles:**
- Keep it simple — start with 2-3 steps, add complexity later
- Test each step individually before chaining them together
- Add delays between actions if needed (some APIs are slow)
- Always include error notifications so you know when things break

---

## Step 4: Build and Test Your Workflow

Now implement it in your chosen tool.

**Build workflow (Zapier example):**
1. **Choose trigger app** (e.g., Google Forms, Typeform, website form)
2. **Connect your account** (authenticate via OAuth)
3. **Test trigger** (submit a test form to make sure data comes through)
4. **Add action** (e.g., "Add row to Google Sheets")
5. **Map fields** (match form fields to spreadsheet columns)
6. **Test action** (run test to verify row is added correctly)
7. **Repeat for additional actions**
8. **Turn on workflow** (Zapier calls this "turn on Zap")

**Testing checklist:**
- [ ] Submit test data through the trigger
- [ ] Verify each action executes correctly
- [ ] Check that data maps to the right fields
- [ ] Test with edge cases (empty fields, special characters, long text)
- [ ] Test error handling (intentionally cause a failure to see if alerts work)

**Common issues and fixes:**

| Issue | Cause | Fix |
|---|---|---|
| Workflow doesn't trigger | Trigger conditions too narrow | Check filter settings, broaden criteria |
| Action fails | API rate limit or permissions | Add delay between actions, re-authenticate |
| Data missing or incorrect | Field mapping wrong | Double-check which fields are mapped |
| Workflow runs multiple times | Duplicate triggers | De-duplicate based on unique ID |

**Rule:** Test with real data before relying on an automation. Don't discover bugs when a real customer is involved.

---

## Step 5: Monitor and Maintain Automations

Automations aren't set-it-and-forget-it. They break. Tools change. APIs update. You need a maintenance plan.

**Weekly check (5 min):**
- Scan workflow logs for errors (most tools show a log of runs + failures)
- Address any failures immediately

**Monthly audit (15 min):**
- Review all active workflows
- Check: Is this still being used? Is it still saving time?
- Disable or delete unused workflows (they clutter your dashboard and can cause confusion)
- Update any workflows that depend on tools you've switched away from

**Where to store workflow documentation:**
- Create a simple doc (Notion, Google Doc) for each workflow
- Include: What it does, when it runs, what apps it connects, how to troubleshoot
- If you have 10+ workflows, this doc will save you hours when something breaks

**Error handling setup:**
- Route all error notifications to one place (Slack channel, email inbox, or task manager)
- Set up: "If any workflow fails, send a message to [your error channel]"
- Review errors weekly and fix root causes

---

## Step 6: Advanced Automation Ideas

Once you've automated the basics, consider these higher-leverage workflows:

### Client onboarding automation
```
TRIGGER: New client signs contract (via DocuSign, HelloSign)
ACTIONS:
  1. Create project in project management tool
  2. Add client to CRM with "Active" status
  3. Send onboarding email sequence
  4. Create invoice in accounting software
  5. Schedule kickoff call on calendar
  6. Add client to Slack workspace (if applicable)
```

### Content distribution automation
```
TRIGGER: New blog post published on website (via RSS or webhook)
ACTIONS:
  1. Post link to LinkedIn with auto-generated caption
  2. Post link to Twitter as a thread
  3. Add post to email newsletter draft (in email tool)
  4. Add to content calendar (Notion or Airtable)
  5. Send notification to team (Slack) that post is live
```

### Customer health monitoring
```
TRIGGER: Every Monday at 9am (scheduled trigger)
ACTIONS:
  1. Pull usage data for all customers from database (via API)
  2. Flag customers with <50% of average usage
  3. Add flagged customers to "At Risk" segment in CRM
  4. Send re-engagement email campaign to at-risk customers
  5. Create task for me to personally reach out to top 10 at-risk customers
```

### Invoice and payment tracking
```
TRIGGER: Payment received (Stripe webhook)
ACTIONS:
  1. Mark invoice as paid in accounting software
  2. Send receipt email to customer
  3. Update CRM: customer status = "Paid"
  4. Add revenue to monthly dashboard (Google Sheets or Airtable)
  5. Send me a Slack notification: "Payment received: $X from [Customer]"
```

---

## Step 7: Calculate Automation ROI

Not every automation is worth the time investment. Calculate ROI to prioritize.

**ROI formula:**
```
Time Saved per Month (hours) = (Minutes per task / 60) × Frequency per month
Cost = (Setup time in hours × $50/hour) + Tool cost per month
Payback Period (months) = Setup cost / Monthly time saved value

If payback period < 3 months → Worth it
If payback period > 6 months → Probably not worth it (unless it unlocks other value)
```

**Example:**
```
Task: Manually copying form submissions to CRM (15 min, 20x/month = 5 hours/month saved)
Setup time: 1 hour
Tool cost: $20/month (Zapier)
Payback: ($50 setup cost) / ($250/month value saved) = 0.2 months → Absolutely worth it
```

**Rule:** Focus on automations with payback < 3 months. Those are your highest-leverage investments.

---

## Automation Mistakes to Avoid
- **Automating before optimizing.** Don't automate a bad process. Fix the process first, then automate it.
- **Over-automating.** Not everything needs to be automated. If a task is rare or requires judgment, do it manually.
- **No error handling.** If an automation breaks and you don't know, it causes silent failures. Always set up error alerts.
- **Not testing thoroughly.** A broken automation is worse than no automation — it creates incorrect data or missed tasks.
- **Building too complex too fast.** Start with simple 2-3 step workflows. Add complexity only when the simple version works perfectly.
- **Not documenting workflows.** Future you will forget how this works. Write it down.
